"use strict";
//
// Copyright 2020-2021 Signal Messenger, LLC.
// SPDX-License-Identifier: AGPL-3.0-only
//
Object.defineProperty(exports, "__esModule", { value: true });
const crypto_1 = require("crypto");
const Constants_1 = require("../internal/Constants");
const Native = require("../../../Native");
const UuidCiphertext_1 = require("./UuidCiphertext");
const ProfileKeyCiphertext_1 = require("./ProfileKeyCiphertext");
const ProfileKey_1 = require("../profiles/ProfileKey");
const Address_1 = require("../../Address");
class ClientZkGroupCipher {
    constructor(groupSecretParams) {
        this.groupSecretParams = groupSecretParams;
    }
    encryptServiceId(serviceId) {
        return new UuidCiphertext_1.default(Native.GroupSecretParams_EncryptServiceId(this.groupSecretParams.getContents(), serviceId.getServiceIdFixedWidthBinary()));
    }
    decryptServiceId(ciphertext) {
        return Address_1.ServiceId.parseFromServiceIdFixedWidthBinary(Native.GroupSecretParams_DecryptServiceId(this.groupSecretParams.getContents(), ciphertext.getContents()));
    }
    encryptProfileKey(profileKey, userId) {
        return new ProfileKeyCiphertext_1.default(Native.GroupSecretParams_EncryptProfileKey(this.groupSecretParams.getContents(), profileKey.getContents(), userId.getServiceIdFixedWidthBinary()));
    }
    decryptProfileKey(profileKeyCiphertext, userId) {
        return new ProfileKey_1.default(Native.GroupSecretParams_DecryptProfileKey(this.groupSecretParams.getContents(), profileKeyCiphertext.getContents(), userId.getServiceIdFixedWidthBinary()));
    }
    encryptBlob(plaintext) {
        const random = (0, crypto_1.randomBytes)(Constants_1.RANDOM_LENGTH);
        return this.encryptBlobWithRandom(random, plaintext);
    }
    encryptBlobWithRandom(random, plaintext) {
        return Native.GroupSecretParams_EncryptBlobWithPaddingDeterministic(this.groupSecretParams.getContents(), random, plaintext, 0);
    }
    decryptBlob(blobCiphertext) {
        return Native.GroupSecretParams_DecryptBlobWithPadding(this.groupSecretParams.getContents(), blobCiphertext);
    }
}
exports.default = ClientZkGroupCipher;
//# sourceMappingURL=ClientZkGroupCipher.js.map